# Complete Deployment Workflow Guide

**Purpose:** Step-by-step guide to start and deploy the entire Email Reports automation workflow

**Created:** 2025-10-31
**Phase:** 8 - Initial Deployment

---

## Table of Contents

1. [Pre-Deployment Testing](#pre-deployment-testing)
2. [First Production Run (Local)](#first-production-run-local)
3. [Server Deployment](#server-deployment)
4. [Production Workflow](#production-workflow)
5. [Troubleshooting](#troubleshooting)

---

## Pre-Deployment Testing

**REQUIRED FIRST STEP:** Complete all testing before proceeding

📄 **See:** [PRE_DEPLOYMENT_TESTING.md](PRE_DEPLOYMENT_TESTING.md)

**Quick Test Command:**
```bash
cd "c:\Apps\Email Reports"
py -3 scripts\testing\run_tests.py
```

**Verify All Pass:**
- ✅ OAuth authentication
- ✅ Client database loading
- ✅ PDF extraction
- ✅ KPI parsing
- ✅ Email generation
- ✅ Gmail integration
- ✅ Approval workflow
- ✅ Cross-platform compatibility

**Do not proceed until all tests pass.**

---

## First Production Run (Local)

### Purpose
Run the complete workflow locally with real production data for the first time.

### Prerequisites

1. **Looker Studio PDFs arrived in Gmail:**
   - Check Gmail inbox
   - Look for emails from Looker Studio sender
   - Should have ~30 PDFs (one per client)
   - Usually arrives in first few days of month

2. **Client database is current:**
   ```bash
   notepad data\clients.csv
   ```
   - Verify all 30 clients listed
   - Check email addresses are correct
   - Ensure PersonalizedText is up-to-date
   - All clients have Active = TRUE

3. **Environment ready:**
   ```bash
   cd "c:\Apps\Email Reports"
   venv\Scripts\activate
   ```

---

### Step 1: Extract PDFs from Gmail

**Command:**
```bash
py -3 main.py --extract-from-gmail
```

**What This Does:**
- Connects to Gmail via API
- Searches for Looker Studio emails
- Downloads all PDF attachments
- Saves to data/pdfs/
- Logs extraction results

**Expected Output:**
```
[2025-11-01 09:00:00] [INFO] [GmailReader] Connecting to Gmail API
[2025-11-01 09:00:05] [INFO] [GmailReader] Found 30 emails from looker-studio@google.com
[2025-11-01 09:00:10] [INFO] [GmailReader] Downloaded: ABC Corporation - October 2025.pdf
...
[2025-11-01 09:05:00] [INFO] [GmailReader] Successfully extracted 30 PDFs
```

**Verify:**
```bash
dir data\pdfs\
# Should show 30 PDF files
```

**If Issues:**
- Check OAuth token is valid
- Verify Gmail API connection
- Check LOOKER_STUDIO_SENDER in .env is correct
- Review logs for error messages

**Estimated Time:** 5-10 minutes

---

### Step 2: Process PDFs and Generate Emails

**Command:**
```bash
py -3 main.py --process-pdfs
```

**What This Does:**
1. Reads all PDFs from data/pdfs/
2. Extracts business name from each PDF
3. Extracts 6 KPI metrics (Sessions, Conversions, Active Users, Engagement Rate, Bounce Rate, Avg Session Duration)
4. Matches business name to client database
5. Generates personalized HTML email for each client
6. Creates approval tracking CSV
7. Creates approval review HTML
8. Saves email previews to data/email_previews/

**Expected Output:**
```
============================================================
PROCESSING PDFS
============================================================

[2025-11-01 09:10:00] [INFO] [PDFExtractor] Processing: ABC Corporation - October 2025.pdf
[2025-11-01 09:10:02] [INFO] [PDFExtractor] Extracted KPIs: Sessions=3,456 | Conversions=127 | ...
[2025-11-01 09:10:03] [INFO] [ClientDatabase] Matched: ABC Corporation -> John (john@abc.com)
[2025-11-01 09:10:05] [INFO] [EmailGenerator] Generated email for: ABC Corporation

...

============================================================
WORKFLOW SUMMARY
============================================================
Total PDFs processed: 30
Emails generated: 28
Approved: 0
Pending: 26
Needs Revision: 2
============================================================

Review emails at: data\approval_review.html
Approval tracking: data\approval_tracking.csv
```

**Estimated Time:** 5-10 minutes

---

### Step 3: Review Generated Emails

**Open approval review HTML:**
```bash
start data\approval_review.html
```

**What to Check:**

For each email:
- ✅ **Business name** matches client
- ✅ **Client first name** is correct
- ✅ **KPI data** looks reasonable (no zeros, no absurd numbers)
- ✅ **Personalized text** is appropriate
- ✅ **Brand colors** visible (#1A4D2E header, #F6E96B highlights)
- ✅ **Signature** present with agency info
- ✅ **PDF attachment** listed

**Status Indicators:**

- **Green (Pending):** No extraction errors, ready for approval
- **Red (Needs Revision):** Extraction errors, requires manual review

**Common Issues to Look For:**

- Business name mismatch (PDF name doesn't match database)
- Missing KPI data (some metrics couldn't be extracted)
- Wrong service type (SEO vs Google Ads)
- Outdated personalized text
- Incorrect client email address

**Estimated Time:** 15-30 minutes (depending on how thorough you want to be)

---

### Step 4: Approve Emails

**Open approval tracking CSV:**
```bash
notepad data\approval_tracking.csv
```

**CSV Structure:**
```
ClientID,FirstName,BusinessName,Email,ServiceType,Status,Notes,ExtractionErrors,EmailFile
1,John,ABC Corporation,john@abc.com,SEO,Pending,,False,ABC_Corporation_preview.html
2,Sarah,XYZ Services,sarah@xyz.com,SEM,Pending,,False,XYZ_Services_preview.html
...
```

**For Each Row:**

1. **Review the email** (open EmailFile in browser if needed)

2. **Update Status column:**
   - Change `Pending` → `Approved` (if email looks good)
   - Change `Pending` → `Needs Revision` (if issues found)

3. **Add Notes** (optional):
   - "KPI data looks good"
   - "Check business name spelling"
   - "Update personalized text next month"

4. **For "Needs Revision":**
   - Add note explaining what needs fixing
   - You'll handle these manually (send from Gmail directly)

**Quick Approve Option:**

If you spot-checked 5-10 emails and they all look perfect:

```bash
py -3 main.py --approve-all
```

**⚠️ Warning:** This auto-approves ALL emails without extraction errors. Only use if you trust the quality.

**Save the file** after making changes.

**Estimated Time:** 10-20 minutes

---

### Step 5: Create Gmail Drafts

**Command:**
```bash
py -3 main.py --create-drafts
```

**What This Does:**
- Reads approval_tracking.csv
- For each "Approved" email:
  - Creates Gmail draft via API
  - Attaches PDF report
  - Sets recipient email address
  - Sets subject line
- Logs draft creation status

**Expected Output:**
```
[2025-11-01 10:00:00] [INFO] [GmailSender] Creating draft for: ABC Corporation
[2025-11-01 10:00:03] [INFO] [GmailSender] Draft created successfully: Draft ID 12345
...
[2025-11-01 10:05:00] [INFO] [GmailSender] Created 28 drafts successfully
```

**Verify in Gmail:**
1. Open Gmail in browser
2. Go to **Drafts** folder
3. Should see ~28 draft emails (one per approved client)

**Estimated Time:** 5-10 minutes

---

### Step 6: Final Review in Gmail

**For Each Draft:**

1. Open draft in Gmail
2. Quick visual check:
   - ✅ Recipient email correct
   - ✅ Subject line correct (e.g., "Your October 2025 SEO Report")
   - ✅ Email body displays properly
   - ✅ Brand colors visible
   - ✅ KPI table formatted correctly
   - ✅ PDF attached
3. Close draft (don't send yet)

**Spot Check:**
- Review 3-5 drafts in detail
- If all look good, trust the rest

**Estimated Time:** 10-15 minutes

---

### Step 7: Send Emails

**Important:** Send manually from Gmail to control pacing

**Recommended Sending Strategy:**

1. **Batch sending** (to avoid spam flags):
   - Send 10 emails
   - Wait 15 minutes
   - Send next 10 emails
   - Wait 15 minutes
   - Send final 8-10 emails

2. **For each draft:**
   - Open in Gmail
   - Click **Send**
   - Gmail moves to Sent folder

3. **Monitor:**
   - Check for bounce-backs
   - Watch for "Message Blocked" warnings
   - Note any delivery failures

**Alternative (Faster):**
- Send all at once (riskier for spam flags)
- Most email providers allow this
- Monitor closely for issues

**Estimated Time:** 30-45 minutes (with spacing)

---

### Step 8: Post-Send Verification

**Check Sent Folder:**
```
Gmail → Sent
```
- Should see all 28-30 sent emails
- Verify timestamps spread out (if you spaced sends)

**Monitor for Bounces:**
- Check inbox for bounce-back messages
- Note any "Delivery Failed" notifications
- Follow up with clients if delivery failed

**Update Client Records:**
- If any emails bounced, update data/clients.csv with new email addresses
- Note any clients who report not receiving email

**Archive PDFs:**
```bash
move data\pdfs\*.pdf data\archive\
```

**Estimated Time:** 10 minutes

---

## First Production Run Complete! 🎉

**What You Accomplished:**
- ✅ Extracted 30 PDFs from Gmail
- ✅ Generated 28-30 personalized emails
- ✅ Reviewed and approved emails
- ✅ Created Gmail drafts via API
- ✅ Sent all client reports

**Total Time:** ~2-3 hours (for first run)

**Future Runs:** 30-45 minutes (once familiar with process)

---

## Server Deployment

### When to Deploy to Server

**Deploy after:**
- First production run successful locally
- All emails delivered without issues
- You're comfortable with the workflow
- Ready to automate monthly runs

### Deployment Steps

#### 1. Prepare Files for Upload

**Run deployment preparation script:**
```bash
py -3 scripts\deployment\prepare_deployment.py
```

This creates a deployment package with:
- All source code
- Configuration files
- Templates
- Requirements
- Excludes: venv/, test PDFs, logs, __pycache__

#### 2. Access cPanel

**Log in to your hosting provider:**
- URL: (your cPanel URL)
- Username: (your username)
- Password: (your password)

#### 3. Create Directory

**In cPanel File Manager:**
1. Navigate to home directory
2. Create new folder: `email_reports`
3. Set permissions: 755

#### 4. Upload Files

**Upload via cPanel File Manager or FTP:**
- Upload deployment package (ZIP)
- Extract in `/home/username/email_reports/`

**OR use FTP client:**
```
Host: your-server.com
Username: your-username
Password: your-password
Directory: /home/username/email_reports/
```

#### 5. Upload Sensitive Files Separately

**⚠️ Important:** Upload these files SEPARATELY (not in ZIP):

```bash
# Upload via cPanel File Manager (secure upload):
- credentials.json
- token.json
- .env
```

**Set permissions:**
```bash
# Via cPanel Terminal or SSH:
chmod 600 /home/username/email_reports/credentials.json
chmod 600 /home/username/email_reports/token.json
chmod 600 /home/username/email_reports/.env
```

#### 6. Update .env for Linux

**Edit .env on server:**
```bash
# Change Windows paths to Linux paths:

# Before (Windows):
CLIENT_DATABASE_PATH=c:/Apps/Email Reports/data/clients.csv
PDF_STORAGE_PATH=c:/Apps/Email Reports/data/pdfs/

# After (Linux):
CLIENT_DATABASE_PATH=/home/username/email_reports/data/clients.csv
PDF_STORAGE_PATH=/home/username/email_reports/data/pdfs/
```

#### 7. Set Up Python Environment

**Via cPanel Terminal or SSH:**

```bash
cd /home/username/email_reports/

# Create virtual environment
python3 -m venv venv

# Activate
source venv/bin/activate

# Install dependencies
pip install -r requirements.txt

# Test
python main.py --help
```

**Expected output:**
```
usage: main.py [-h] [--full] [--extract-from-gmail] ...
```

#### 8. Test on Server

**Run dry run:**
```bash
python main.py --process-pdfs
```

**Check logs:**
```bash
cat logs/email_reports_2025-11-01.log
```

#### 9. Set Up Cron Job

**In cPanel Cron Jobs:**

1. Navigate to: **Advanced → Cron Jobs**
2. Add new cron job:

**Schedule:** 1st of month at 9:00 AM
```
0 9 1 * * /home/username/email_reports/venv/bin/python /home/username/email_reports/main.py --full >> /home/username/email_reports/logs/cron.log 2>&1
```

**Breakdown:**
- `0 9 1 * *` = 9:00 AM on 1st of every month
- Runs full workflow automatically
- Logs output to cron.log

3. **Set email notification:**
   - Add your email to receive cron errors
   - cPanel will email you if cron job fails

#### 10. Test Cron Job

**Manual test:**
```bash
# Via SSH:
/home/username/email_reports/venv/bin/python /home/username/email_reports/main.py --help
```

**Scheduled test:**
- Set temporary cron for 5 minutes from now
- Verify it runs successfully
- Check logs
- Delete temporary cron

---

## Production Workflow (Monthly)

### Automated (Server) Workflow

**1st of Each Month:**
1. Cron job runs automatically at 9:00 AM
2. Extracts PDFs from Gmail
3. Processes PDFs and generates emails
4. Creates approval tracking CSV
5. Sends notification (if configured)

**Your Tasks:**
1. Check cron.log for success
2. Review approval_tracking.csv via cPanel
3. Approve emails
4. Run create-drafts (or set up auto-approve)
5. Send drafts from Gmail

### Manual (Local) Workflow

**If Not Using Server:**

**Monthly on 1st:**
```bash
cd "c:\Apps\Email Reports"
py -3 main.py --full
```

Follow steps 3-8 from "First Production Run" above.

---

## Troubleshooting

### Common Issues

#### "OAuth token expired"
**Solution:**
```bash
# Re-authenticate:
py -3 tests\test_oauth.py
```

#### "No PDFs found to process"
**Check:**
- Looker Studio emails arrived in Gmail
- LOOKER_STUDIO_SENDER in .env is correct
- Run: `py -3 main.py --extract-from-gmail`

#### "Client database not found"
**Check:**
- data/clients.csv exists
- Path in .env is correct (Windows vs Linux)
- File permissions (Linux: should be readable)

#### "Failed to create Gmail draft"
**Check:**
- OAuth scope includes gmail.compose
- Internet connection working
- Gmail API quota not exceeded
- Check logs for specific error

#### "KPI extraction failed for some PDFs"
**Check:**
- PDF format hasn't changed
- Open PDF manually to verify it's readable
- Check logs for specific extraction errors
- May need to update pdf_extractor.py

#### Emails Going to Spam
**Solutions:**
- Send in smaller batches (10 at a time)
- Space sends 15 minutes apart
- Ask clients to whitelist your email
- Check SPF/DKIM records in Google Workspace

### Getting Help

1. **Check logs:**
   ```bash
   type logs\email_reports_2025-11-01.log
   ```

2. **Review documentation:**
   - [README.md](README.md#troubleshooting)
   - [docs/user-guides/USAGE.md](docs/user-guides/USAGE.md)
   - [docs/implementation/](docs/implementation/)

3. **Run diagnostics:**
   ```bash
   py -3 scripts\utilities\setup_verify.py
   ```

---

## Timeline Summary

### First Production Run (Local)
- Pre-deployment testing: 2-3 hours (one-time)
- First production run: 2-3 hours
- **Total:** 4-6 hours

### Future Monthly Runs (Local)
- Extract PDFs: 5 minutes
- Process & generate: 10 minutes
- Review emails: 15 minutes
- Approve: 10 minutes
- Create drafts: 5 minutes
- Send emails: 30 minutes (with spacing)
- **Total:** ~75 minutes per month

### Server Deployment (One-Time)
- File upload: 30 minutes
- Environment setup: 30 minutes
- Testing: 30 minutes
- Cron configuration: 15 minutes
- **Total:** ~2 hours

### Future Monthly Runs (Server)
- Automated processing: 0 minutes (cron does it)
- Review & approve: 20 minutes
- Send emails: 30 minutes
- **Total:** ~50 minutes per month

---

## Success Criteria

✅ **System is successful when:**
- All 30 PDFs extracted from Gmail
- 28-30 emails generated without errors
- All approved emails sent successfully
- No client reports missing data
- Process takes < 1 hour (after first run)
- Zero manual intervention after approval

---

## Next Phase

After 1-2 successful production runs:

**Phase 9: Optimization**
- Monitor for 3 months
- Collect performance metrics
- Implement improvements
- Consider auto-send feature
- Add AI-powered insights (future)

---

**Status:** ⏳ READY TO START
**Last Updated:** 2025-10-31
**Phase:** 8 - Initial Deployment

**Get Started:** [PRE_DEPLOYMENT_TESTING.md](PRE_DEPLOYMENT_TESTING.md)
