# Monthly Report Run - Quick Instructions

## What Happens Automatically

When you run the monthly workflow, the system automatically:
1. **Archives** old PDFs from `data/pdfs/` to `data/pdfs/archive/[Previous Month]/`
2. **Downloads** new PDFs from Google Drive (for the specified month)
3. **Processes** PDFs and extracts KPI data
4. **Generates** personalized HTML emails
5. **Creates** approval tracking spreadsheet + web preview

## Monthly Workflow - Step by Step

### Option A: Current Month (Auto-Detect Previous Month)

If it's early November and you want to process October reports:

```bash
python main.py --full
```

**What happens:**
- Archives October PDFs (if any exist in `data/pdfs/`)
- Auto-detects previous month (October)
- Downloads PDFs from `Google Ads/Reports/2025/October/` and `SEO/Reports/2025/October/`
- Generates emails and approval sheet

---

### Option B: Specific Month (Manual Override)

If you need to process a specific month (e.g., September):

```bash
python main.py --full --month September
```

**What happens:**
- Archives all non-September PDFs
- Downloads from `Google Ads/Reports/2025/September/` and `SEO/Reports/2025/September/`
- Generates emails for September reports

---

## Complete Monthly Process

### 1. **Run Workflow** (5-10 minutes)

```bash
cd "c:\Apps\Email Reports"
python main.py --full
```

**Expected output:**
- "Archived X files, skipped Y" (old PDFs moved to archive)
- "Downloaded Z PDF files" (new PDFs from Google Drive)
- "Processing X PDF files"
- "Generating emails"
- Link to Google Sheets approval tracker
- Link to web preview page

---

### 2. **Review & Approve** (10-20 minutes)

Open the links provided in the terminal output:

**Option A - Google Sheets:**
- Review each email's details
- Change Status from "Pending" to "Approved" for emails ready to send
- Add notes for any that need revision

**Option B - Web Preview:**
- Open the HTML preview page (shows exact email appearance)
- Visual confirmation of email formatting

---

### 3. **Create Gmail Drafts** (2-3 minutes)

After approving emails in the Google Sheet:

```bash
python main.py --create-drafts
```

**Expected output:**
- "Creating Gmail drafts for X approved emails..."
- "[OK] Client Name (Business Name)" for each draft created
- "Created X Gmail drafts"

---

### 4. **Send From Gmail** (30-60 minutes, spaced out)

1. Open Gmail and go to **Drafts** folder
2. Send emails manually, spacing them out:
   - Send 5-10 emails
   - Wait 10-15 minutes
   - Send next batch
3. Monitor for any bounce-backs or delivery failures

---

## Archive Structure

After each run, your archive will look like this:

```
data/pdfs/
  ├── archive/
  │   ├── October 2025/         ← Old PDFs automatically moved here
  │   │   ├── Client A - October 2025 SEO Report.pdf
  │   │   ├── Client B - October 2025 SEO Report.pdf
  │   │   └── ...
  │   ├── September 2025/
  │   │   └── ...
  │   └── email_previews/
  │       ├── October 2025/     ← Old HTML previews
  │       └── September 2025/
  │
  ├── Client A - November 2025 SEO Report.pdf    ← Current month PDFs
  ├── Client B - November 2025 SEO Report.pdf
  └── ...
```

---

## Troubleshooting

### "No PDFs found to process"
- Check Google Drive folders exist:
  - `Shared drives\DWS\SEO\Reports\2025\[Month]`
  - `Shared drives\DWS\Google Ads\Reports\2025\[Month]`
- Verify month name spelling (e.g., "January" not "Jan")

### "No emails were approved"
- Open the Google Sheets link
- Change Status column from "Pending" to "Approved"
- Run `python main.py --create-drafts` again

### "Archived too many files"
- Check archive folder: `data/pdfs/archive/`
- PDFs are safe and can be moved back if needed
- Archiving only happens when filenames don't match current month

---

## Quick Reference Commands

| Task | Command |
|------|---------|
| **Full monthly run** (auto-detect month) | `python main.py --full` |
| **Specific month** | `python main.py --full --month January` |
| **Create drafts** (after approval) | `python main.py --create-drafts` |
| **Extract PDFs only** (no email generation) | `python main.py --extract-from-drive` |
| **Process existing PDFs** (skip download) | `python main.py --process-pdfs` |

---

## Notes

- **Archive happens automatically** at the start of `--full` workflow
- **Month auto-detection** assumes you run the system early in the month (processes previous month)
- **Manual month override** useful for testing or catching up on missed months
- **Approval is required** - system never sends emails without your explicit approval
- **Drafts are safer than auto-send** - gives you final review in Gmail before sending

---

## Support

- Check logs in `logs/` folder for detailed error information
- Review `CLAUDE.md` for full system documentation
- Archive is in `data/pdfs/archive/` if you need to retrieve old PDFs
