"""
Quick script to check Google Sheet contents
"""
import gspread
from google.oauth2.credentials import Credentials
from google.auth.transport.requests import Request
import os
import json

# OAuth setup
SCOPES = [
    'https://www.googleapis.com/auth/spreadsheets',
    'https://www.googleapis.com/auth/drive.file'
]

creds = None
token_path = 'token.json'
credentials_path = 'credentials.json'

if os.path.exists(token_path):
    creds = Credentials.from_authorized_user_file(token_path, SCOPES)

if not creds or not creds.valid:
    if creds and creds.expired and creds.refresh_token:
        creds.refresh(Request())
        with open(token_path, 'w') as token:
            token.write(creds.to_json())

# Connect to Google Sheets
gc = gspread.authorize(creds)

# Open the sheet
sheet_id = '14IZDLSw5L6I0y_8FZZvMVrr90Pbk67mZqHVo7MCNa_k'
spreadsheet = gc.open_by_key(sheet_id)
worksheet = spreadsheet.sheet1

# Get all values
all_values = worksheet.get_all_values()

print(f"\n{'='*80}")
print(f"Google Sheet Contents - First 10 rows")
print(f"{'='*80}\n")

# Print header
if all_values:
    header = all_values[0]
    print(f"Headers: {header}\n")

    # Find Report Type column index
    if 'Report Type' in header:
        report_type_idx = header.index('Report Type')
        print(f"Report Type column index: {report_type_idx}\n")
    else:
        print("WARNING: 'Report Type' column not found in header!\n")
        report_type_idx = None

# Print first 10 data rows
for i, row in enumerate(all_values[1:11], 1):  # Skip header, show first 10
    if report_type_idx is not None and report_type_idx < len(row):
        report_type = row[report_type_idx]
        business_name = row[1] if len(row) > 1 else 'N/A'
        print(f"Row {i}: {business_name:30} | Report Type: {report_type}")
    else:
        print(f"Row {i}: {row[:5]}")  # Show first 5 columns

print(f"\n{'='*80}\n")
