# Email Reports Workflow Guide

## Phase 5: Google Drive Integration with Month-Based Processing

### Overview
The system automatically downloads PDF reports from your Google Shared Drive, organized by month folders.

**Folder Structure:**
```
Shared drives\DWS\SEO\Reports\2025\
├── January\
├── February\
├── March\
└── ...

Shared drives\DWS\Google Ads\Reports\2025\
├── January\
├── February\
├── March\
└── ...
```

---

## Quick Start

### 1. Setup (One-time)

Update your `.env` file with the folder IDs:

```bash
# These IDs point to the 2025 year folders
DRIVE_SEO_FOLDER_ID=1BpQKQcZ9YO0lJVKtywL0berbt-k9cjuc
DRIVE_SEM_FOLDER_ID=1AoEF52KRdQFblgcKg2mfLJmhCgSGIGKv
```

**Note:** You'll need to update these IDs each year when you create new year folders.

---

### 2. Monthly Workflow

#### Option A: Automatic Month Detection (Recommended)
The system automatically processes the previous month's reports:

```bash
python main.py --full
```

**Example:** If today is February 5, 2025, it will process January reports.

#### Option B: Specify a Specific Month
Process a different month manually:

```bash
python main.py --full --month "January"
python main.py --full --month "December"
```

**Use Cases:**
- Processing late reports
- Reprocessing a month with corrections
- Processing December reports in January (year rollover)

---

## What Happens During Processing

1. **Auto-detects Month:** Calculates previous month (or uses your `--month` override)
2. **Downloads SEO Reports:** Finds the month folder in SEO Reports and downloads all PDFs
3. **Downloads Google Ads Reports:** Finds the month folder in Google Ads Reports and downloads all PDFs
4. **Processes PDFs:** Extracts KPIs and matches to client database
5. **Generates Emails:** Creates personalized emails for each client
6. **Creates Approval Sheet:** Google Sheet for review and approval
7. **Waits for Your Approval:** You review and mark emails as "Approved"
8. **Creates Gmail Drafts:** After approval, creates drafts ready to send

---

## Common Commands

### Process Current Month's Reports (Auto-detect)
```bash
python main.py --full
```

### Process Specific Month
```bash
python main.py --full --month "November"
```

### Extract PDFs Only (No Email Generation)
```bash
python main.py --extract-from-drive --month "January"
```

### Create Drafts After Approval
```bash
python main.py --create-drafts
```

---

## Year Rollover (Important!)

### When 2026 Begins

1. **Create New Year Folders in Google Drive:**
   - `Shared drives\DWS\SEO\Reports\2026\`
   - `Shared drives\DWS\Google Ads\Reports\2026\`

2. **Get New Folder IDs:**
   - Right-click the `2026` folder → "Get link"
   - Extract the folder ID from the URL
   - Example: `https://drive.google.com/drive/folders/1ABC...` → `1ABC...`

3. **Update `.env` File:**
   ```bash
   DRIVE_SEO_FOLDER_ID=<new_2026_seo_folder_id>
   DRIVE_SEM_FOLDER_ID=<new_2026_sem_folder_id>
   ```

4. **Processing December 2025 in January 2026:**
   ```bash
   # First, temporarily switch back to 2025 folder IDs in .env
   python main.py --full --month "December"

   # Then update .env to 2026 folder IDs for future months
   ```

---

## Troubleshooting

### "No PDFs found to process"

**Possible Causes:**
1. Month folder doesn't exist in Google Drive
2. Month name misspelled (use full name: "January", not "Jan")
3. Folder IDs in `.env` are incorrect
4. No PDFs uploaded to that month's folder yet

**Solution:**
- Check folder structure in Google Drive
- Verify folder IDs in `.env` match your Drive folders
- Use `--month` to specify the correct month name

### "Subfolder 'January' not found in parent..."

**Cause:** The month folder hasn't been created yet in Google Drive.

**Solution:**
1. Go to Google Drive
2. Navigate to the year folder (e.g., `2025`)
3. Create the month folder (e.g., `January`)
4. Upload PDFs to that folder
5. Run the command again

---

## Month Name Reference

Use these exact month names (case-insensitive):
- January
- February
- March
- April
- May
- June
- July
- August
- September
- October
- November
- December

---

## Example Scenarios

### Scenario 1: Normal Monthly Processing (Early February)
```bash
# Auto-detects "January" and processes January reports
python main.py --full
```

### Scenario 2: Processing Late Reports (Mid-February)
```bash
# December reports just arrived, process them manually
python main.py --full --month "December"
```

### Scenario 3: Reprocessing After Corrections
```bash
# Client data was updated, reprocess January
python main.py --full --month "January"
```

### Scenario 4: Year-End Processing (Early January 2026)
```bash
# Process December 2025 reports with 2025 folder IDs still in .env
python main.py --full --month "December"

# Then update .env to 2026 folder IDs for future processing
```

---

## Integration with Existing Workflow

The Google Drive integration replaces Gmail PDF extraction. Your workflow now:

**Old:** Looker Studio → Email → Manual Download → Process
**New:** Looker Studio → Google Drive → **Automatic Download** → Process

Everything else remains the same:
- Client database (CSV)
- Approval workflow (Google Sheets)
- Gmail draft creation
- Manual sending with spacing

---

## Support

**Configuration Issues:** Check `.env` file has correct folder IDs

**Month Detection Issues:** Use `--month` to override automatic detection

**Google Drive Access:** Ensure OAuth token (`token.json`) has Drive read permissions

**Questions:** Review logs in `logs/` directory for detailed error messages
