"""Quick script to regenerate web preview from existing email data."""

import json
from pathlib import Path
from src.web_preview import WebPreviewGenerator

# Load existing generated emails
with open('data/last_generated_emails.json', 'r', encoding='utf-8') as f:
    data = json.load(f)
    emails = data.get('emails', [])

# Generate preview
generator = WebPreviewGenerator('output')
preview_path = generator.generate_preview_page(emails, 'October')

print(f"\nWeb preview regenerated: {preview_path}")
print(f"\nOpen this file in your browser to see the updated formatting:")
print(f"file:///{preview_path.replace(chr(92), '/')}")
