"""
Test runner script for Email Reports Automation System.
Runs all unit and integration tests with pytest.
"""

import sys
import subprocess
from pathlib import Path

def main():
    """Run all tests with pytest."""
    project_root = Path(__file__).parent
    tests_dir = project_root / 'tests'

    print("=" * 70)
    print("Running Email Reports Automation System Tests")
    print("=" * 70)
    print(f"Project Root: {project_root}")
    print(f"Tests Directory: {tests_dir}")
    print("=" * 70)

    # Check if pytest is installed
    try:
        import pytest
        print(f"pytest version: {pytest.__version__}")
    except ImportError:
        print("ERROR: pytest not installed")
        print("Install with: pip install pytest pytest-cov")
        return 1

    # Run pytest
    args = [
        '-v',  # Verbose output
        '--tb=short',  # Short traceback format
        '--color=yes',  # Colored output
        str(tests_dir)
    ]

    print(f"\nRunning: pytest {' '.join(args)}\n")
    print("=" * 70)

    # Run pytest programmatically
    exit_code = pytest.main(args)

    print("\n" + "=" * 70)
    if exit_code == 0:
        print("ALL TESTS PASSED ✓")
    else:
        print(f"TESTS FAILED (exit code: {exit_code})")
    print("=" * 70)

    return exit_code


if __name__ == '__main__':
    sys.exit(main())
