"""Test script to show new template formatting with one sample email."""

from src.email_generator import EmailGenerator
from pathlib import Path

# Sample client data (using APC Prosthetics as example)
client_data = {
    'Client-Name': 'APC Prosthetics',
    'Contact-Name': 'Rosalina',
    'Contact-Email': 'test@example.com',
    'SEO-Introduction': '<p>Throughout the month we have been focusing upon on-page and off-page SEO to improve the websites online presence.</p><p>You can find your current keyword rankings in the same attached SEO report.</p>'
}

# Sample extracted data
extracted_data = {
    'report_type': 'SEO',
    'report_month': 'October 2025',
    'kpis': {
        'Sessions': {'value': '5,568', 'change': '50.9%'},
        'Active users': {'value': '3,568', 'change': '44.2%'},
        'New users': {'value': '3,439', 'change': '45.2%'},
        'Key events': {'value': '182', 'change': '41.1%'},
        'Engagement rate': {'value': '54.67%', 'change': '-0.4%'},
        'Bounce rate': {'value': '45.33%', 'change': '0.5%'},
        'Average session duration': {'value': '00:03:17', 'change': '6.7%'}
    }
}

# Config
config = {
    'AGENCY_NAME': 'Discover Web Solutions',
    'AGENCY_EMAIL': 'craig@discoverweb.com.au',
    'AGENCY_PHONE': '+61 412 312 542',
    'AGENCY_WEBSITE': 'discoverweb.solutions',
    'STANDARD_SEO_PARAGRAPH': 'The following shows some key KPI data for Organic Search Traffic ONLY. These KPIs will help to track visitor traffic resulting from SEO activities.'
}

# Generate email
generator = EmailGenerator('templates/email_template.html', config)
email = generator.generate_email(client_data, extracted_data)

# Save to output file
output_path = Path('output/test_email_sample.html')
output_path.parent.mkdir(exist_ok=True)

with open(output_path, 'w', encoding='utf-8') as f:
    f.write(email['html_body'])

print(f"\nTest email generated with NEW template:")
print(f"file:///{output_path.absolute().as_posix()}")
print(f"\nThis shows:")
print(f"  ✓ Larger font size (16px)")
print(f"  ✓ Left-aligned content")
print(f"  ✓ NO signature block")
