"""
Quick test to debug Drive download issue.
"""
import os
from dotenv import load_dotenv
from src.drive_reader import DriveReader
from datetime import datetime
from dateutil.relativedelta import relativedelta

load_dotenv()

# Get September
last_month = datetime.now() - relativedelta(months=1)
month = last_month.strftime('%B')

print(f"Testing download for month: {month}")

# Initialize Drive
drive = DriveReader()

# Get folder IDs from .env
seo_folder = os.getenv('DRIVE_SEO_FOLDER_ID')
sem_folder = os.getenv('DRIVE_SEM_FOLDER_ID')

print(f"\nSEO Folder ID: {seo_folder}")
print(f"SEM Folder ID: {sem_folder}")

# Find September subfolder in SEO
print(f"\nLooking for '{month}' in SEO folder...")
seo_month_folder = drive.find_subfolder_by_name(seo_folder, month)
print(f"Result: {seo_month_folder}")

if seo_month_folder:
    print(f"\nListing PDFs in SEO {month} folder...")
    pdfs = drive.list_pdfs_in_folder(seo_month_folder)
    print(f"Found {len(pdfs)} PDFs")

    if pdfs:
        print(f"\nFirst 3 PDFs:")
        for pdf in pdfs[:3]:
            print(f"  - {pdf['name']}")

# Find September subfolder in SEM
print(f"\nLooking for '{month}' in SEM folder...")
sem_month_folder = drive.find_subfolder_by_name(sem_folder, month)
print(f"Result: {sem_month_folder}")

if sem_month_folder:
    print(f"\nListing PDFs in SEM {month} folder...")
    pdfs = drive.list_pdfs_in_folder(sem_month_folder)
    print(f"Found {len(pdfs)} PDFs")
